package Juno2;

import java.io.*;
import java.util.HashMap;
import java.util.*;
import javax.servlet.http.*;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CmdPositionListHandler extends org.apache.struts.action.Action implements RequestHandler {

    public CmdEventFactory factory = new CmdEventFactory();

    //public ActionForward perform(ActionMapping mapping, ActionForm form,
    public ActionForward execute(ActionMapping mapping, ActionForm form,
                    javax.servlet.http.HttpServletRequest request,
                    javax.servlet.http.HttpServletResponse response) 
    {
        ////System.out.println("CmdPositionListHandler perform() invoked");   										
        try {
	   		processRequest(request);
        } catch (Exception e) {
	        System.out.println("CmdPositionListHandler processRequest threw exception: " + e.getMessage());
        }
        
        ////System.out.println("CmdPositionListHandler about to ActionForward()");   		
   		ActionForward result = mapping.findForward(CmdConstants.SUCCESS_KEY);
   		////System.out.println("mapping.findForward: " + result.toString());
   		return result;
	}   		 	


	public void processRequest(HttpServletRequest request) throws Exception, CmdException
	{
        CmdCreateEvent event = null;
       	try{
	 		event= (CmdCreateEvent)factory.extractEvent(request);
        } catch (Exception e) {
            System.out.println("CmdCreateEvent exception");
            throw new CmdException("Fatal error creating PositionList event. " +e);
        }
        HttpSession session = null;
        try {
			session=request.getSession();
        }catch (Exception e) {
			System.out.println("request.getSession() exception");
			throw new CmdException("Fatal error getting session. " +e);
    	}
        CmdVO info = null;
   		try {
        	info=event.getInfo();
    	} catch (Exception e){
			System.out.println("event.getInfo() exception");
			throw new CmdException("Fatal error getting event. " +e);
    	}

		CmdPositionListImpl plImpl = new CmdPositionListImpl();	
		PositionListCVO plcvo = plImpl.doPositionList(info.getUserId(), info.getUserPassword(), info.getAccountId());
		     
        session.setAttribute("PositionList",plcvo.getPositionList());

		session.setAttribute("EquityList",plcvo.getEquityList());
 	}
}
